#!/bin/sh
#
# Copyright (C) 2020, Cirrent Inc
#
# All use of this software must be covered by a license agreement signed by Cirrent Inc.
#
# DISCLAIMER. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OR CONDITION,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. LICENSORS HEREBY DISCLAIM
# ALL LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE.
#

parse_input_data()
{
    options=$(getopt -l "count:,interval:" -o "hv:Vrd" -a -- "$@")
    eval set -- "$options"

    while true; do
        case $1 in
            -c|--count)
                SAMPLE_COUNT="$2"
                ;;
            -i|--interval)
                SAMPLING_INTERVAL="$2"
                ;;
            --)
                shift
                break
                ;;
        esac
        shift
    done
}

DIAGNOSTIC_DIR="/etc/cirrent/diagnostics"
DIAGNOSTIC_ID="$1"
DIAGNOSTIC_TYPE="$2"
DIAGNOSTIC_INPUT_DATA="$3"
DIAGNOSTIC_RESULT_FILE="/tmp/cirrent/diagnostic-${DIAGNOSTIC_TYPE}-${DIAGNOSTIC_ID}"

RESULT="FAILED"
SAMPLE_COUNT=1
SAMPLING_INTERVAL=0
parse_input_data $DIAGNOSTIC_INPUT_DATA

rm "$DIAGNOSTIC_RESULT_FILE"

count=1
while [ $count -le $SAMPLE_COUNT ]; do
    echo "SAMPLE_COUNT=$count" >> "$DIAGNOSTIC_RESULT_FILE"
    date >> "$DIAGNOSTIC_RESULT_FILE"

    case "$DIAGNOSTIC_TYPE" in
        "collect_logs")
            ((
                set -x
                cat /var/log/syslog
            ) 2>&1 ) >> "$DIAGNOSTIC_RESULT_FILE"
            RESULT="SUCCESS"
            ;;
        "network_profile")
            ((
                set -x
                cat /proc/net/dev
                cat /proc/net/arp
                ip rule | while read rt; do
                    echo "$rt"
                    ip r sh t $(echo $rt | rev | cut -d' ' -f1 | rev)
                done
                ss -anop
                cat /etc/resolv.conf
            ) 2>&1 ) >> "$DIAGNOSTIC_RESULT_FILE"
            RESULT="SUCCESS"
            ;;
        *)
            if [ ! -x "${DIAGNOSTIC_DIR}/${DIAGNOSTIC_TYPE}" ]; then
                echo "Unknown diagnostic type $DIAGNOSTIC_TYPE" >> "$DIAGNOSTIC_RESULT_FILE"
                break
            fi
            (
                "${DIAGNOSTIC_DIR}/${DIAGNOSTIC_TYPE}" 2>&1
            ) >> "$DIAGNOSTIC_RESULT_FILE"
            RESULT="SUCCESS"
            ;;
    esac

    sleep $SAMPLING_INTERVAL
    count=$(expr $count + 1)
done

cirrent_cli send_diagnostic_result "$DIAGNOSTIC_ID" "$RESULT" "$DIAGNOSTIC_RESULT_FILE"

exit 0
