/**
 * @file xmc4_usic_map.h
 * @date 2015-10-27
 *
 * @cond
*********************************************************************************************************************
 * XMClib v2.1.2 - XMC Peripheral Driver Library 
 *
 * Copyright (c) 2015, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the 
 * following conditions are met:   
 *                                                                              
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 * disclaimer.                        
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials provided with the distribution.                       
 * 
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 * products derived from this software without specific prior written permission.                                           
 *                                                                              
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE  
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                  
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with 
 * Infineon Technologies AG dave@infineon.com).                                                          
 *********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-02-20:
 *     - Initial version
 *
 * 2015-08-25:
 *     - Added XMC4800
 *      
 * @endcond 
 *
 */

#ifndef XMC4_USIC_MAP_H
#define XMC4_USIC_MAP_H

/*******************************************************************************
 * MACROS
 *******************************************************************************/
 
#define USIC_INPUT_ALWAYS_1     7

#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == VQFN48)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == VQFN48)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == VQFN48)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == VQFN48)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP100)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP100)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == BGA144)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P4_7   	2
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P3_13  	3
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX0_P6_3   	2
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_P6_2   	2
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_P6_1   	2
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_P5_8   	1
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_P5_9   	1
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX0_P3_14  	1
#define USIC1_C1_DX0_P3_15  	0
#define USIC1_C1_DX0_P4_2   	2
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P0_13  	1
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P3_7   	2
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_P5_3   	0
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_12  	3
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_P4_2   	0
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP100)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP144)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P4_7   	2
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P3_13  	3
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX0_P6_3   	2
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_P6_2   	2
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_P6_1   	2
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_P5_8   	1
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_P5_9   	1
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX0_P3_14  	1
#define USIC1_C1_DX0_P3_15  	0
#define USIC1_C1_DX0_P4_2   	2
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P0_13  	1
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P3_7   	2
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_P5_3   	0
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_12  	3
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_P4_2   	0
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4502) && (UC_PACKAGE == LQFP100)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP100)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP144)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P4_7   	2
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P3_13  	3
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX0_P6_3   	2
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_P6_2   	2
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_P6_1   	2
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_P5_8   	1
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_P5_9   	1
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX0_P3_14  	1
#define USIC1_C1_DX0_P3_15  	0
#define USIC1_C1_DX0_P4_2   	2
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P0_13  	1
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P3_7   	2
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_P5_3   	0
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_12  	3
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_P4_2   	0
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == BGA196)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P4_7   	2
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX0_P8_8   	4
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_P8_3   	2
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_P8_1   	2
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P3_13  	3
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX0_P6_3   	2
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_P6_2   	2
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_P6_1   	2
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_P5_8   	1
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_P5_9   	1
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX0_P3_14  	1
#define USIC1_C1_DX0_P3_15  	0
#define USIC1_C1_DX0_P4_2   	2
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P0_13  	1
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P3_7   	2
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_P9_1   	2
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_P5_3   	0
#define USIC2_C0_DX2_P9_0   	2
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_12  	3
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_P4_2   	0
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP100)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP144)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P4_7   	2
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P3_13  	3
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX0_P6_3   	2
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_P6_2   	2
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_P6_1   	2
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_P5_8   	1
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_P5_9   	1
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX0_P3_14  	1
#define USIC1_C1_DX0_P3_15  	0
#define USIC1_C1_DX0_P4_2   	2
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P0_13  	1
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P3_7   	2
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_P5_3   	0
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_12  	3
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_P4_2   	0
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == BGA196)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P4_7   	2
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX0_P8_8   	4
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_P8_3   	2
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_P8_1   	2
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P3_13  	3
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX0_P6_3   	2
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_P6_2   	2
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_P6_1   	2
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_P5_8   	1
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_P5_9   	1
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX0_P3_14  	1
#define USIC1_C1_DX0_P3_15  	0
#define USIC1_C1_DX0_P4_2   	2
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P0_13  	1
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P3_7   	2
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_P9_1   	2
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_P5_3   	0
#define USIC2_C0_DX2_P9_0   	2
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_12  	3
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_P4_2   	0
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP100)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP144)
#define USIC0_C0_DX0_DOUT0  	6
#define USIC0_C0_DX0_P1_4   	1
#define USIC0_C0_DX0_P1_5   	0
#define USIC0_C0_DX0_P4_7   	2
#define USIC0_C0_DX0_P5_0   	3
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	0
#define USIC0_C0_DX1_SCLKOUT	6
#define USIC0_C0_DX2_CCU40_SR1	4
#define USIC0_C0_DX2_CCU80_SR1	5
#define USIC0_C0_DX2_P0_7   	1
#define USIC0_C0_DX2_P1_0   	0
#define USIC0_C0_DX2_SELO0  	6
#define USIC0_C0_DX3_DOUT1  	6
#define USIC0_C0_DX4_DOUT2  	6
#define USIC0_C0_DX5_DOUT3  	6
#define USIC0_C1_DX0_DOUT0  	6
#define USIC0_C1_DX0_P2_2   	0
#define USIC0_C1_DX0_P2_5   	1
#define USIC0_C1_DX0_P3_13  	3
#define USIC0_C1_DX0_P4_0   	4
#define USIC0_C1_DX0_P6_3   	2
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_P2_4   	0
#define USIC0_C1_DX1_P3_0   	1
#define USIC0_C1_DX1_P6_2   	2
#define USIC0_C1_DX1_SCLKOUT	6
#define USIC0_C1_DX2_CCU42_SR1	4
#define USIC0_C1_DX2_CCU80_SR1	5
#define USIC0_C1_DX2_P2_3   	0
#define USIC0_C1_DX2_P3_1   	1
#define USIC0_C1_DX2_P6_1   	2
#define USIC0_C1_DX2_SELO0  	6
#define USIC0_C1_DX3_DOUT1  	6
#define USIC0_C1_DX4_DOUT2  	6
#define USIC0_C1_DX5_DOUT3  	6
#define USIC1_C0_DX0_DOUT0  	6
#define USIC1_C0_DX0_P0_4   	0
#define USIC1_C0_DX0_P0_5   	1
#define USIC1_C0_DX0_P2_14  	3
#define USIC1_C0_DX0_P2_15  	2
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_P0_11  	0
#define USIC1_C0_DX1_P5_8   	1
#define USIC1_C0_DX1_SCLKOUT	6
#define USIC1_C0_DX2_CCU41_SR1	4
#define USIC1_C0_DX2_CCU81_SR1	5
#define USIC1_C0_DX2_P0_6   	0
#define USIC1_C0_DX2_P5_9   	1
#define USIC1_C0_DX2_SELO0  	6
#define USIC1_C0_DX3_DOUT1  	6
#define USIC1_C0_DX4_DOUT2  	6
#define USIC1_C0_DX5_DOUT3  	6
#define USIC1_C1_DX0_DOUT0  	6
#define USIC1_C1_DX0_P0_0   	3
#define USIC1_C1_DX0_P3_14  	1
#define USIC1_C1_DX0_P3_15  	0
#define USIC1_C1_DX0_P4_2   	2
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_P0_10  	0
#define USIC1_C1_DX1_P0_13  	1
#define USIC1_C1_DX1_P4_0   	2
#define USIC1_C1_DX1_SCLKOUT	6
#define USIC1_C1_DX2_CCU43_SR1	4
#define USIC1_C1_DX2_CCU81_SR1	5
#define USIC1_C1_DX2_P0_12  	1
#define USIC1_C1_DX2_P0_9   	0
#define USIC1_C1_DX2_SELO0  	6
#define USIC1_C1_DX3_DOUT1  	6
#define USIC1_C1_DX4_DOUT2  	6
#define USIC1_C1_DX5_DOUT3  	6
#define USIC2_C0_DX0_DOUT0  	6
#define USIC2_C0_DX0_P3_7   	2
#define USIC2_C0_DX0_P5_0   	1
#define USIC2_C0_DX0_P5_1   	0
#define USIC2_C0_DX1_DX0INS 	5
#define USIC2_C0_DX1_P5_2   	0
#define USIC2_C0_DX1_SCLKOUT	6
#define USIC2_C0_DX2_CCU41_SR1	4
#define USIC2_C0_DX2_CCU81_SR1	5
#define USIC2_C0_DX2_P5_3   	0
#define USIC2_C0_DX2_SELO0  	6
#define USIC2_C0_DX3_DOUT1  	6
#define USIC2_C0_DX4_DOUT2  	6
#define USIC2_C0_DX5_DOUT3  	6
#define USIC2_C1_DX0_DOUT0  	6
#define USIC2_C1_DX0_P3_12  	3
#define USIC2_C1_DX0_P3_4   	1
#define USIC2_C1_DX0_P3_5   	0
#define USIC2_C1_DX0_P4_0   	2
#define USIC2_C1_DX1_DX0INS 	5
#define USIC2_C1_DX1_P3_6   	1
#define USIC2_C1_DX1_P4_2   	0
#define USIC2_C1_DX1_SCLKOUT	6
#define USIC2_C1_DX2_CCU43_SR1	4
#define USIC2_C1_DX2_CCU81_SR1	5
#define USIC2_C1_DX2_P4_1   	0
#define USIC2_C1_DX2_SELO0  	6
#define USIC2_C1_DX3_DOUT1  	6
#define USIC2_C1_DX4_DOUT2  	6
#define USIC2_C1_DX5_DOUT3  	6
#endif

#endif /* XMC4_USIC_MAP_H */
