/**
 * @file xmc4_eru_map.h
 * @date 2015-10-27
 *
 * @cond
 *********************************************************************************************************************
 * XMClib v2.1.2 - XMC Peripheral Driver Library 
 *
 * Copyright (c) 2015, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the 
 * following conditions are met:   
 *                                                                              
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 * disclaimer.                        
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials provided with the distribution.                       
 * 
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 * products derived from this software without specific prior written permission.                                           
 *                                                                              
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE  
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                  
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with 
 * Infineon Technologies AG dave@infineon.com).                                                          
 *********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-02-20:
 *     - Initial version
 *
 * @endcond
 */

#ifndef XMC4_ERU_MAP_H
#define XMC4_ERU_MAP_H

/*********************************************************************************************************************
 * MACROS
 *********************************************************************************************************************/
#define ERU0_ETL0 XMC_ERU0, 0
#define ERU0_ETL1 XMC_ERU0, 1
#define ERU0_ETL2 XMC_ERU0, 2
#define ERU0_ETL3 XMC_ERU0, 3

#define ERU0_OGU0 XMC_ERU0, 0
#define ERU0_OGU1 XMC_ERU0, 1
#define ERU0_OGU2 XMC_ERU0, 2
#define ERU0_OGU3 XMC_ERU0, 3

#define ERU1_ETL0 XMC_ERU1, 0
#define ERU1_ETL1 XMC_ERU1, 1
#define ERU1_ETL2 XMC_ERU1, 2
#define ERU1_ETL3 XMC_ERU1, 3

#define ERU1_OGU0 XMC_ERU1, 0
#define ERU1_OGU1 XMC_ERU1, 1
#define ERU1_OGU2 XMC_ERU1, 2
#define ERU1_OGU3 XMC_ERU1, 3

#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == LQFP64)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == VQFN48)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == LQFP64)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == VQFN48)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == LQFP64)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == VQFN48)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == LQFP64)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == VQFN48)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP100)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP64)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP100)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP64)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_HRPWM0_CNO        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == BGA144)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_13             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP100)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP144)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_13             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4502) && (UC_PACKAGE == LQFP100)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP100)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP144)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_13             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == BGA196)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_13             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP100)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP144)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_13             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == BGA196)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_13             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP100)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP144)
#define ERU0_ETL0_INPUTA_P0_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL0_INPUTA_P2_5              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL0_INPUTA_P3_2              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL0_INPUTA_SCU_G0ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL0_INPUTB_P0_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL0_INPUTB_P2_0              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL0_INPUTB_P2_4              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL0_INPUTB_P3_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTA_P0_10             	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL1_INPUTA_P2_3              	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL1_INPUTA_SCU_G0ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL1_INPUTA_SCU_HIB_SR0       	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL1_INPUTB_P0_1              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL1_INPUTB_P0_9              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL1_INPUTB_P2_2              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL1_INPUTB_P2_6              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTA_P0_13             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL2_INPUTA_P0_8              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL2_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL2_INPUTA_SCU_G1ORCOUT6     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL2_INPUTB_P0_12             	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL2_INPUTB_P0_4              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL2_INPUTB_P0_7              	XMC_ERU_ETL_INPUT_B1
#define ERU0_ETL2_INPUTB_P1_4              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTA_P0_11             	XMC_ERU_ETL_INPUT_A2
#define ERU0_ETL3_INPUTA_P1_1              	XMC_ERU_ETL_INPUT_A0
#define ERU0_ETL3_INPUTA_P3_6              	XMC_ERU_ETL_INPUT_A1
#define ERU0_ETL3_INPUTA_SCU_G1ORCOUT7     	XMC_ERU_ETL_INPUT_A3
#define ERU0_ETL3_INPUTB_P0_2              	XMC_ERU_ETL_INPUT_B3
#define ERU0_ETL3_INPUTB_P0_6              	XMC_ERU_ETL_INPUT_B2
#define ERU0_ETL3_INPUTB_P1_0              	XMC_ERU_ETL_INPUT_B0
#define ERU0_ETL3_INPUTB_P3_5              	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTA_CCU40_ST0         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL0_INPUTA_DAC_SGN_0         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL0_INPUTA_P1_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL0_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL0_INPUTB_CCU80_ST0         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL0_INPUTB_ERU1_IOUT3        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL0_INPUTB_P2_1              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL0_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL1_INPUTA_CCU40_ST1         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL1_INPUTA_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL1_INPUTA_P1_15             	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL1_INPUTA_POSIF0_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL1_INPUTB_CCU80_ST1         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL1_INPUTB_ERU1_IOUT2        	XMC_ERU_ETL_INPUT_B3
#define ERU1_ETL1_INPUTB_P2_7              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL1_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL2_INPUTA_CCU40_ST2         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL2_INPUTA_DAC_SGN_1         	XMC_ERU_ETL_INPUT_A3
#define ERU1_ETL2_INPUTA_P1_3              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL2_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL2_INPUTB_CCU80_ST2         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL2_INPUTB_P1_2              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL2_INPUTB_VADC0_G0BFLOUT3   	XMC_ERU_ETL_INPUT_B2
#define ERU1_ETL3_INPUTA_CCU40_ST3         	XMC_ERU_ETL_INPUT_A2
#define ERU1_ETL3_INPUTA_P0_5              	XMC_ERU_ETL_INPUT_A0
#define ERU1_ETL3_INPUTA_POSIF1_SR1        	XMC_ERU_ETL_INPUT_A1
#define ERU1_ETL3_INPUTB_CCU80_ST3         	XMC_ERU_ETL_INPUT_B1
#define ERU1_ETL3_INPUTB_P0_3              	XMC_ERU_ETL_INPUT_B0
#define ERU1_ETL3_INPUTB_VADC0_G1BFLOUT3   	XMC_ERU_ETL_INPUT_B2

#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXH  	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU0_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_CCU40_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU0_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU0_PERIPHERAL_TRIGGER_VADC_C0SR0	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU1_PERIPHERAL_TRIGGER_CCU41_ST0	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU1_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU1_PERIPHERAL_TRIGGER_VADC_C0SR1	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU2_PERIPHERAL_TRIGGER_CCU81_STA3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU2_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU2_PERIPHERAL_TRIGGER_VADC_C0SR2	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#define ERU1_OGU3_PERIPHERAL_TRIGGER_CCU81_STB3	XMC_ERU_OGU_PERIPHERAL_TRIGGER2
#define ERU1_OGU3_PERIPHERAL_TRIGGER_FIXL  	XMC_ERU_OGU_PERIPHERAL_TRIGGER3
#define ERU1_OGU3_PERIPHERAL_TRIGGER_VADC_C0SR3	XMC_ERU_OGU_PERIPHERAL_TRIGGER1
#endif

#endif /* XMC4_ERU_MAP_H */
