/**
 * @file xmc4_ccu8_map.h
 * @date 2015-10-27
 *
 * @cond
 *********************************************************************************************************************
 * XMClib v2.1.2 - XMC Peripheral Driver Library 
 *
 * Copyright (c) 2015, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the 
 * following conditions are met:   
 *                                                                              
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 * disclaimer.                        
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials provided with the distribution.                       
 * 
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 * products derived from this software without specific prior written permission.                                           
 *                                                                              
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE  
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                  
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with 
 * Infineon Technologies AG dave@infineon.com).                                                          
 *********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-08-25:
 *     - Initial version
 *
 * @endcond
 */

#ifndef XMC4_CCU8_MAP_H
#define XMC4_CCU8_MAP_H

#define XMC_CCU8_SLICE_INPUT_A (0U)
#define XMC_CCU8_SLICE_INPUT_B (1U)
#define XMC_CCU8_SLICE_INPUT_C (2U)
#define XMC_CCU8_SLICE_INPUT_D (3U)
#define XMC_CCU8_SLICE_INPUT_E (4U)
#define XMC_CCU8_SLICE_INPUT_F (5U)
#define XMC_CCU8_SLICE_INPUT_G (6U)
#define XMC_CCU8_SLICE_INPUT_H (7U)
#define XMC_CCU8_SLICE_INPUT_I (8U)
#define XMC_CCU8_SLICE_INPUT_J (9U)
#define XMC_CCU8_SLICE_INPUT_K (10U)
#define XMC_CCU8_SLICE_INPUT_L (11U)
#define XMC_CCU8_SLICE_INPUT_M (12U)
#define XMC_CCU8_SLICE_INPUT_N (13U)
#define XMC_CCU8_SLICE_INPUT_O (14U)
#define XMC_CCU8_SLICE_INPUT_P (15U)

#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == LQFP64)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#endif


#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == VQFN48)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == LQFP64)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == VQFN48)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == LQFP64)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == VQFN48)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == LQFP64)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == VQFN48)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP100)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP64)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP100)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP64)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_HRPWM0_C0O               	12
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_HRPWM0_C1O               	13
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_HRPWM0_C2O               	14
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_HRPWM0_C0O               	15
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == BGA144)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_13                    	2
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P3_13                    	2
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P3_12                    	2
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_P5_3                     	1
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P3_11                    	2
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_P5_4                     	1
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP100)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP144)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_13                    	2
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P3_13                    	2
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P3_12                    	2
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_P5_3                     	1
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P3_11                    	2
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_P5_4                     	1
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4502) && (UC_PACKAGE == LQFP100)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP100)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP144)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_13                    	2
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P3_13                    	2
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P3_12                    	2
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_P5_3                     	1
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P3_11                    	2
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_P5_4                     	1
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == BGA196)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_13                    	2
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P3_13                    	2
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P3_12                    	2
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_P5_3                     	1
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P3_11                    	2
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_P5_4                     	1
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP100)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP144)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_13                    	2
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P3_13                    	2
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P3_12                    	2
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_P5_3                     	1
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P3_11                    	2
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_P5_4                     	1
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == BGA196)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_13                    	2
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P3_13                    	2
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P3_12                    	2
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_P5_3                     	1
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P3_11                    	2
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_P5_4                     	1
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP100)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP144)
#define CCU80_IN0_CCU40_SR3                	10
#define CCU80_IN0_CCU80_ST0                	12
#define CCU80_IN0_CCU80_ST1                	13
#define CCU80_IN0_CCU80_ST2                	14
#define CCU80_IN0_CCU80_ST3                	15
#define CCU80_IN0_CCU81_SR3                	11
#define CCU80_IN0_ERU1_PDOUT0              	9
#define CCU80_IN0_P0_7                     	0
#define CCU80_IN0_P3_2                     	2
#define CCU80_IN0_P3_4                     	1
#define CCU80_IN0_POSIF0_OUT2              	3
#define CCU80_IN0_POSIF0_OUT5              	4
#define CCU80_IN0_SCU_ERU1_IOUT0           	6
#define CCU80_IN0_SCU_GSC80                	7
#define CCU80_IN0_VADC0_G0BFL0             	8
#define CCU80_IN0_VADC0_G0SR3              	5
#define CCU80_IN1_CCU41_SR3                	10
#define CCU80_IN1_CCU80_ST0                	12
#define CCU80_IN1_CCU80_ST1                	13
#define CCU80_IN1_CCU80_ST2                	14
#define CCU80_IN1_CCU80_ST3                	15
#define CCU80_IN1_CCU81_SR3                	11
#define CCU80_IN1_ERU1_PDOUT0              	9
#define CCU80_IN1_ERU1_PDOUT1              	5
#define CCU80_IN1_P0_7                     	0
#define CCU80_IN1_P0_8                     	1
#define CCU80_IN1_P3_1                     	2
#define CCU80_IN1_POSIF0_OUT2              	3
#define CCU80_IN1_POSIF0_OUT5              	4
#define CCU80_IN1_SCU_ERU1_IOUT1           	6
#define CCU80_IN1_SCU_GSC80                	7
#define CCU80_IN1_VADC0_G0BFL1             	8
#define CCU80_IN2_CCU42_SR3                	10
#define CCU80_IN2_CCU80_ST0                	12
#define CCU80_IN2_CCU80_ST1                	13
#define CCU80_IN2_CCU80_ST2                	14
#define CCU80_IN2_CCU80_ST3                	15
#define CCU80_IN2_CCU81_SR3                	11
#define CCU80_IN2_ERU1_PDOUT0              	9
#define CCU80_IN2_ERU1_PDOUT2              	5
#define CCU80_IN2_P0_6                     	1
#define CCU80_IN2_P0_7                     	0
#define CCU80_IN2_P3_0                     	2
#define CCU80_IN2_POSIF0_OUT2              	3
#define CCU80_IN2_POSIF0_OUT5              	4
#define CCU80_IN2_SCU_ERU1_IOUT2           	6
#define CCU80_IN2_SCU_GSC80                	7
#define CCU80_IN2_VADC0_G0BFL2             	8
#define CCU80_IN3_CCU43_SR3                	10
#define CCU80_IN3_CCU80_ST0                	12
#define CCU80_IN3_CCU80_ST1                	13
#define CCU80_IN3_CCU80_ST2                	14
#define CCU80_IN3_CCU80_ST3                	15
#define CCU80_IN3_CCU81_SR3                	11
#define CCU80_IN3_ERU1_PDOUT0              	9
#define CCU80_IN3_ERU1_PDOUT3              	5
#define CCU80_IN3_P0_7                     	0
#define CCU80_IN3_P3_13                    	2
#define CCU80_IN3_P3_3                     	1
#define CCU80_IN3_POSIF0_OUT2              	3
#define CCU80_IN3_POSIF0_OUT5              	4
#define CCU80_IN3_SCU_ERU1_IOUT3           	6
#define CCU80_IN3_SCU_GSC80                	7
#define CCU80_IN3_VADC0_G0BFL3             	8
#define CCU81_IN0_CCU40_SR3                	10
#define CCU81_IN0_CCU80_SR3                	11
#define CCU81_IN0_CCU81_ST0                	12
#define CCU81_IN0_CCU81_ST1                	13
#define CCU81_IN0_CCU81_ST2                	14
#define CCU81_IN0_CCU81_ST3                	15
#define CCU81_IN0_ERU1_PDOUT0              	5
#define CCU81_IN0_ERU1_PDOUT1              	8
#define CCU81_IN0_P3_0                     	2
#define CCU81_IN0_P5_0                     	0
#define CCU81_IN0_P5_1                     	1
#define CCU81_IN0_POSIF1_OUT2              	3
#define CCU81_IN0_POSIF1_OUT5              	4
#define CCU81_IN0_SCU_ERU1_IOUT0           	6
#define CCU81_IN0_SCU_GSC81                	7
#define CCU81_IN0_VADC0_G0SR3              	9
#define CCU81_IN1_CCU41_SR3                	10
#define CCU81_IN1_CCU80_SR3                	11
#define CCU81_IN1_CCU81_ST0                	12
#define CCU81_IN1_CCU81_ST1                	13
#define CCU81_IN1_CCU81_ST2                	14
#define CCU81_IN1_CCU81_ST3                	15
#define CCU81_IN1_ERU1_PDOUT0              	8
#define CCU81_IN1_P3_13                    	2
#define CCU81_IN1_P5_0                     	0
#define CCU81_IN1_P5_2                     	1
#define CCU81_IN1_POSIF1_OUT2              	3
#define CCU81_IN1_POSIF1_OUT5              	4
#define CCU81_IN1_SCU_ERU1_IOUT1           	6
#define CCU81_IN1_SCU_GSC81                	7
#define CCU81_IN1_VADC0_G1SR3              	9
#define CCU81_IN2_CCU42_SR3                	10
#define CCU81_IN2_CCU80_SR3                	11
#define CCU81_IN2_CCU81_ST0                	12
#define CCU81_IN2_CCU81_ST1                	13
#define CCU81_IN2_CCU81_ST2                	14
#define CCU81_IN2_CCU81_ST3                	15
#define CCU81_IN2_ERU1_PDOUT1              	8
#define CCU81_IN2_ERU1_PDOUT2              	5
#define CCU81_IN2_P3_12                    	2
#define CCU81_IN2_P5_0                     	0
#define CCU81_IN2_P5_3                     	1
#define CCU81_IN2_POSIF1_OUT2              	3
#define CCU81_IN2_POSIF1_OUT5              	4
#define CCU81_IN2_SCU_ERU1_IOUT2           	6
#define CCU81_IN2_SCU_GSC81                	7
#define CCU81_IN2_VADC0_G2SR3              	9
#define CCU81_IN3_CCU43_SR3                	10
#define CCU81_IN3_CCU80_SR3                	11
#define CCU81_IN3_CCU81_ST0                	12
#define CCU81_IN3_CCU81_ST1                	13
#define CCU81_IN3_CCU81_ST2                	14
#define CCU81_IN3_CCU81_ST3                	15
#define CCU81_IN3_ERU1_PDOUT1              	8
#define CCU81_IN3_ERU1_PDOUT3              	5
#define CCU81_IN3_P3_11                    	2
#define CCU81_IN3_P5_0                     	0
#define CCU81_IN3_P5_4                     	1
#define CCU81_IN3_POSIF1_OUT2              	3
#define CCU81_IN3_POSIF1_OUT5              	4
#define CCU81_IN3_SCU_ERU1_IOUT3           	6
#define CCU81_IN3_SCU_GSC81                	7
#define CCU81_IN3_VADC0_G3SR3              	9
#endif

#endif /* XMC4_CCU8_MAP_H */
