/**
 * @file xmc4_ccu4_map.h
 * @date 2015-10-27
 *
 * @cond
 *********************************************************************************************************************
 * XMClib v2.1.2 - XMC Peripheral Driver Library 
 *
 * Copyright (c) 2015, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the 
 * following conditions are met:   
 *                                                                              
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 * disclaimer.                        
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials provided with the distribution.                       
 * 
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 * products derived from this software without specific prior written permission.                                           
 *                                                                              
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE  
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                  
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with 
 * Infineon Technologies AG dave@infineon.com).                                                          
 *********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-08-25:
 *     - Initial version
 *
 * @endcond
 */

#ifndef XMC4_CCU4_MAP_H
#define XMC4_CCU4_MAP_H

#define XMC_CCU4_SLICE_INPUT_A (0U)
#define XMC_CCU4_SLICE_INPUT_B (1U)
#define XMC_CCU4_SLICE_INPUT_C (2U)
#define XMC_CCU4_SLICE_INPUT_D (3U)
#define XMC_CCU4_SLICE_INPUT_E (4U)
#define XMC_CCU4_SLICE_INPUT_F (5U)
#define XMC_CCU4_SLICE_INPUT_G (6U)
#define XMC_CCU4_SLICE_INPUT_H (7U)
#define XMC_CCU4_SLICE_INPUT_I (8U)
#define XMC_CCU4_SLICE_INPUT_J (9U)
#define XMC_CCU4_SLICE_INPUT_K (10U)
#define XMC_CCU4_SLICE_INPUT_L (11U)
#define XMC_CCU4_SLICE_INPUT_M (12U)
#define XMC_CCU4_SLICE_INPUT_N (13U)
#define XMC_CCU4_SLICE_INPUT_O (14U)
#define XMC_CCU4_SLICE_INPUT_P (15U)

#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#endif


#if (UC_DEVICE == XMC4100) && (UC_PACKAGE == VQFN48)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#endif


#if (UC_DEVICE == XMC4104) && (UC_PACKAGE == VQFN48)
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#endif


#if (UC_DEVICE == XMC4108) && (UC_PACKAGE == VQFN48)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#endif


#if (UC_DEVICE == XMC4200) && (UC_PACKAGE == VQFN48)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP100)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_HRPWM0_QOUT3             	7
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_HRPWM0_QOUT1             	7
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_HRPWM0_QOUT2             	7
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4400) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_HRPWM0_QOUT3             	7
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_HRPWM0_QOUT1             	7
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_HRPWM0_QOUT2             	7
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP100)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_HRPWM0_QOUT3             	7
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_HRPWM0_QOUT1             	7
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_HRPWM0_QOUT2             	7
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4402) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_HRPWM0_QOUT3             	7
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_HRPWM0_QOUT1             	7
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_HRPWM0_QOUT2             	7
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == BGA144)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_15                    	2
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_14                    	2
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P0_15                    	2
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P0_14                    	2
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_P4_6                     	0
#define CCU43_IN0_P4_7                     	2
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_P4_2                     	2
#define CCU43_IN1_P4_5                     	0
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_13                    	2
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_P4_4                     	0
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_12                    	2
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_P4_3                     	0
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP100)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4500) && (UC_PACKAGE == LQFP144)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_15                    	2
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_14                    	2
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P0_15                    	2
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P0_14                    	2
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_P4_6                     	0
#define CCU43_IN0_P4_7                     	2
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_P4_2                     	2
#define CCU43_IN1_P4_5                     	0
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_13                    	2
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_P4_4                     	0
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_12                    	2
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_P4_3                     	0
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4502) && (UC_PACKAGE == LQFP100)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP100)
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4504) && (UC_PACKAGE == LQFP144)
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_15                    	2
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_14                    	2
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P0_15                    	2
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P0_14                    	2
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_P4_6                     	0
#define CCU43_IN0_P4_7                     	2
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_P4_2                     	2
#define CCU43_IN1_P4_5                     	0
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_13                    	2
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_P4_4                     	0
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_12                    	2
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_P4_3                     	0
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == BGA196)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_15                    	2
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_14                    	2
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P0_15                    	2
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P0_14                    	2
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_P4_6                     	0
#define CCU43_IN0_P4_7                     	2
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_P4_2                     	2
#define CCU43_IN1_P4_5                     	0
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_13                    	2
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_P4_4                     	0
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_12                    	2
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_P4_3                     	0
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP100)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4700) && (UC_PACKAGE == LQFP144)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_15                    	2
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_14                    	2
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P0_15                    	2
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P0_14                    	2
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_P4_6                     	0
#define CCU43_IN0_P4_7                     	2
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_P4_2                     	2
#define CCU43_IN1_P4_5                     	0
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_13                    	2
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_P4_4                     	0
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_12                    	2
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_P4_3                     	0
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == BGA196)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_15                    	2
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_14                    	2
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P0_15                    	2
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P0_14                    	2
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_P4_6                     	0
#define CCU43_IN0_P4_7                     	2
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_P4_2                     	2
#define CCU43_IN1_P4_5                     	0
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_13                    	2
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_P4_4                     	0
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_12                    	2
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_P4_3                     	0
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP100)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif


#if (UC_DEVICE == XMC4800) && (UC_PACKAGE == LQFP144)
#define CCU40_IN0_CAN0_SR7                 	7
#define CCU40_IN0_CCU40_ST0                	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU1_PDOUT0              	9
#define CCU40_IN0_ERU1_PDOUT1              	3
#define CCU40_IN0_P1_3                     	0
#define CCU40_IN0_P2_1                     	2
#define CCU40_IN0_P2_8                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ERU1_IOUT0           	10
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_ST0                	12
#define CCU40_IN1_CCU40_ST1                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU1_PDOUT0              	3
#define CCU40_IN1_ERU1_PDOUT1              	9
#define CCU40_IN1_P1_2                     	0
#define CCU40_IN1_P2_0                     	2
#define CCU40_IN1_P2_8                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT2              	11
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ERU1_IOUT1           	10
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN2_CCU40_ST0                	12
#define CCU40_IN2_CCU40_ST1                	13
#define CCU40_IN2_CCU40_ST2                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU1_PDOUT0              	3
#define CCU40_IN2_ERU1_PDOUT2              	9
#define CCU40_IN2_P1_1                     	0
#define CCU40_IN2_P2_7                     	2
#define CCU40_IN2_P2_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ERU1_IOUT2           	10
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN2_U0C1_DX2INS              	11
#define CCU40_IN3_CCU40_ST0                	12
#define CCU40_IN3_CCU40_ST1                	13
#define CCU40_IN3_CCU40_ST2                	14
#define CCU40_IN3_CCU40_ST3                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU1_PDOUT0              	3
#define CCU40_IN3_ERU1_PDOUT3              	9
#define CCU40_IN3_P1_0                     	0
#define CCU40_IN3_P2_6                     	2
#define CCU40_IN3_P2_8                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ERU1_IOUT3           	10
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_U1C0_DX2INS              	11
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CAN0_SR7                 	7
#define CCU41_IN0_CCU41_ST0                	12
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU1_PDOUT0              	9
#define CCU41_IN0_ERU1_PDOUT1              	3
#define CCU41_IN0_P1_4                     	2
#define CCU41_IN0_P2_5                     	0
#define CCU41_IN0_P2_9                     	1
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ERU1_IOUT0           	10
#define CCU41_IN0_SCU_GSC41                	8
#define CCU41_IN0_VADC0_G0BFL0             	11
#define CCU41_IN1_CCU41_ST0                	12
#define CCU41_IN1_CCU41_ST1                	13
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU1_PDOUT0              	3
#define CCU41_IN1_ERU1_PDOUT1              	9
#define CCU41_IN1_P1_5                     	2
#define CCU41_IN1_P2_4                     	0
#define CCU41_IN1_P2_9                     	1
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT2              	11
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ERU1_IOUT1           	10
#define CCU41_IN1_SCU_GSC41                	8
#define CCU41_IN2_CCU41_ST0                	12
#define CCU41_IN2_CCU41_ST1                	13
#define CCU41_IN2_CCU41_ST2                	14
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU1_PDOUT0              	3
#define CCU41_IN2_ERU1_PDOUT2              	9
#define CCU41_IN2_P1_10                    	2
#define CCU41_IN2_P2_3                     	0
#define CCU41_IN2_P2_9                     	1
#define CCU41_IN2_POSIF1_OUT0              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ERU1_IOUT2           	10
#define CCU41_IN2_SCU_GSC41                	8
#define CCU41_IN2_VADC0_G0BFL1             	11
#define CCU41_IN3_CCU41_ST0                	12
#define CCU41_IN3_CCU41_ST1                	13
#define CCU41_IN3_CCU41_ST2                	14
#define CCU41_IN3_CCU41_ST3                	15
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU1_PDOUT0              	3
#define CCU41_IN3_ERU1_PDOUT3              	9
#define CCU41_IN3_P1_11                    	2
#define CCU41_IN3_P2_2                     	0
#define CCU41_IN3_P2_9                     	1
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ERU1_IOUT3           	10
#define CCU41_IN3_SCU_GSC41                	8
#define CCU41_IN3_VADC0_G0BFL2             	11
#define CCU41_IN3_VADC0_G1ARBCNT           	6
#define CCU42_IN0_CCU42_ST0                	12
#define CCU42_IN0_CCU42_ST1                	13
#define CCU42_IN0_CCU42_ST2                	14
#define CCU42_IN0_CCU42_ST3                	15
#define CCU42_IN0_CCU80_IGBTO              	7
#define CCU42_IN0_ERU1_PDOUT0              	9
#define CCU42_IN0_ERU1_PDOUT1              	3
#define CCU42_IN0_P2_15                    	1
#define CCU42_IN0_P3_15                    	2
#define CCU42_IN0_P3_6                     	0
#define CCU42_IN0_POSIF0_OUT2              	4
#define CCU42_IN0_POSIF0_OUT5              	5
#define CCU42_IN0_SCU_ERU1_IOUT0           	10
#define CCU42_IN0_SCU_GSC42                	8
#define CCU42_IN0_U0C0_DX2INS              	11
#define CCU42_IN1_CCU42_ST0                	12
#define CCU42_IN1_CCU42_ST1                	13
#define CCU42_IN1_CCU42_ST2                	14
#define CCU42_IN1_CCU42_ST3                	15
#define CCU42_IN1_ERU1_PDOUT0              	3
#define CCU42_IN1_ERU1_PDOUT1              	9
#define CCU42_IN1_P2_15                    	1
#define CCU42_IN1_P3_14                    	2
#define CCU42_IN1_P3_5                     	0
#define CCU42_IN1_POSIF0_OUT2              	4
#define CCU42_IN1_POSIF0_OUT5              	5
#define CCU42_IN1_SCU_ERU1_IOUT1           	10
#define CCU42_IN1_SCU_GSC42                	8
#define CCU42_IN1_U0C1_DX2INS              	11
#define CCU42_IN2_CAN0_SR7                 	6
#define CCU42_IN2_CCU42_ST0                	12
#define CCU42_IN2_CCU42_ST1                	13
#define CCU42_IN2_CCU42_ST2                	14
#define CCU42_IN2_CCU42_ST3                	15
#define CCU42_IN2_ERU1_PDOUT0              	3
#define CCU42_IN2_ERU1_PDOUT2              	9
#define CCU42_IN2_P0_15                    	2
#define CCU42_IN2_P2_15                    	1
#define CCU42_IN2_P3_4                     	0
#define CCU42_IN2_POSIF0_OUT2              	4
#define CCU42_IN2_POSIF0_OUT5              	5
#define CCU42_IN2_SCU_ERU1_IOUT2           	10
#define CCU42_IN2_SCU_GSC42                	8
#define CCU42_IN2_U1C0_DX2INS              	11
#define CCU42_IN3_CCU42_ST0                	12
#define CCU42_IN3_CCU42_ST1                	13
#define CCU42_IN3_CCU42_ST2                	14
#define CCU42_IN3_CCU42_ST3                	15
#define CCU42_IN3_ERU1_PDOUT0              	3
#define CCU42_IN3_ERU1_PDOUT3              	9
#define CCU42_IN3_P0_14                    	2
#define CCU42_IN3_P2_15                    	1
#define CCU42_IN3_P3_3                     	0
#define CCU42_IN3_POSIF0_OUT2              	4
#define CCU42_IN3_POSIF0_OUT5              	5
#define CCU42_IN3_SCU_ERU1_IOUT3           	10
#define CCU42_IN3_SCU_GSC42                	8
#define CCU42_IN3_U1C1_DX2INS              	11
#define CCU42_IN3_VADC0_G2ARBCNT           	6
#define CCU43_IN0_CCU43_ST0                	12
#define CCU43_IN0_CCU43_ST1                	13
#define CCU43_IN0_CCU43_ST2                	14
#define CCU43_IN0_CCU43_ST3                	15
#define CCU43_IN0_CCU81_IGBTO              	6
#define CCU43_IN0_ERU1_PDOUT0              	9
#define CCU43_IN0_ERU1_PDOUT1              	3
#define CCU43_IN0_P2_14                    	1
#define CCU43_IN0_P4_6                     	0
#define CCU43_IN0_P4_7                     	2
#define CCU43_IN0_POSIF1_OUT2              	4
#define CCU43_IN0_POSIF1_OUT5              	5
#define CCU43_IN0_SCU_ERU1_IOUT0           	10
#define CCU43_IN0_SCU_GSC43                	8
#define CCU43_IN0_U0C0_DX2INS              	11
#define CCU43_IN0_VADC0_G0BFL0             	7
#define CCU43_IN1_CAN0_SR7                 	6
#define CCU43_IN1_CCU43_ST0                	12
#define CCU43_IN1_CCU43_ST1                	13
#define CCU43_IN1_CCU43_ST2                	14
#define CCU43_IN1_CCU43_ST3                	15
#define CCU43_IN1_ERU1_PDOUT0              	3
#define CCU43_IN1_ERU1_PDOUT1              	9
#define CCU43_IN1_P2_14                    	1
#define CCU43_IN1_P4_2                     	2
#define CCU43_IN1_P4_5                     	0
#define CCU43_IN1_POSIF1_OUT2              	4
#define CCU43_IN1_POSIF1_OUT5              	5
#define CCU43_IN1_SCU_ERU1_IOUT1           	10
#define CCU43_IN1_SCU_GSC43                	8
#define CCU43_IN1_U0C1_DX2INS              	11
#define CCU43_IN1_VADC0_G1BFL0             	7
#define CCU43_IN2_CCU43_ST0                	12
#define CCU43_IN2_CCU43_ST1                	13
#define CCU43_IN2_CCU43_ST2                	14
#define CCU43_IN2_CCU43_ST3                	15
#define CCU43_IN2_ERU1_PDOUT0              	3
#define CCU43_IN2_ERU1_PDOUT2              	9
#define CCU43_IN2_P2_13                    	2
#define CCU43_IN2_P2_14                    	1
#define CCU43_IN2_P4_4                     	0
#define CCU43_IN2_POSIF1_OUT2              	4
#define CCU43_IN2_POSIF1_OUT5              	5
#define CCU43_IN2_SCU_ERU1_IOUT2           	10
#define CCU43_IN2_SCU_GSC43                	8
#define CCU43_IN2_U1C0_DX2INS              	11
#define CCU43_IN2_VADC0_G2BFL0             	7
#define CCU43_IN3_CCU43_ST0                	12
#define CCU43_IN3_CCU43_ST1                	13
#define CCU43_IN3_CCU43_ST2                	14
#define CCU43_IN3_CCU43_ST3                	15
#define CCU43_IN3_ERU1_PDOUT0              	3
#define CCU43_IN3_ERU1_PDOUT3              	9
#define CCU43_IN3_P2_12                    	2
#define CCU43_IN3_P2_14                    	1
#define CCU43_IN3_P4_3                     	0
#define CCU43_IN3_POSIF1_OUT2              	4
#define CCU43_IN3_POSIF1_OUT5              	5
#define CCU43_IN3_SCU_ERU1_IOUT3           	10
#define CCU43_IN3_SCU_GSC43                	8
#define CCU43_IN3_U1C1_DX2INS              	11
#define CCU43_IN3_VADC0_G3ARBCNT           	6
#define CCU43_IN3_VADC0_G3BFL0             	7
#endif

#endif /* XMC4_CCU4_MAP_H */
