;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   AMPINV_1.asm  ( AMPINV )
;;  Version: 4.1, Updated on 2003/11/18 at 14:58:56
;;  Generated by PSoC Designer ver 4.1 b931 : 21 January, 2004
;;
;;  DESCRIPTION: AMPINV User Module software implementation file
;;               for the 22/24/27xxx PSoC family of devices
;;
;;  NOTE: User Module APIs conform to the fastcall convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API
;;        function returns. Even though these registers may be preserved now,
;;        there is no guarantee they will be preserved in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2001-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

    ;; -----------------------------------------------------------------
    ;;                         Register Definitions
    ;; -----------------------------------------------------------------
    ;;
    ;; Uses 2 Continuous Time Blocks configured as shown. This API depends
    ;; on knowing the exact personalization of CR0 and CR3 bitfields
    ;; for time efficiency.
    ;;
    ;; * For a Mask/Val pair, this indicates that the value is
    ;;   determined by the user either through config-time parameteriza-
    ;;   tion or run-time manipulation.
    ;;
    ;; BIT FIELD             Mask/Val   Function
    ;; -----------------        -----   --------------------
    ;;
    ;; INVAMP_CR0.RMux           F0/*   User Parameter (by table)
    ;; INVAMP_CR0.GAIN           08/1   Gain
    ;; INVAMP_CR0.RTMux          04/1   Res source to output
    ;; INVAMP_CR0.RBMux          03/*   User Parameter
    ;;
    ;; INVAMP_CR1.AnalogBus      80/*   User Parameter (init: DISABLE)
    ;; INVAMP_CR1.CmpBus         40/0   Comparator bus disabled
    ;; INVAMP_CR1.NMux           38/4    Neg mux to analog f.b. tap
    ;; INVAMP_CR1.PMux           07/3    Pos mux to AGND
    ;;
    ;; INVAMP_CR2.CPhase         80/0    Latch transparent on PH1
    ;; INVAMP_CR2.CLatch         40/0    Latch transparent
    ;; INVAMP_CR2.Comp           20/1    Mode OP-AMP (not comparator)
    ;; INVAMP_CR2.OMux           1C/0    Bypass OFF
    ;; INVAMP_CR2.Power          03/0    Power OFF at start-up

include "AMPINV_1.inc"
include "m8c.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  AMPINV_1_Start
export _AMPINV_1_Start
export  AMPINV_1_SetPower
export _AMPINV_1_SetPower
export  AMPINV_1_SetGain
export _AMPINV_1_SetGain
export  AMPINV_1_Stop
export _AMPINV_1_Stop

;-----------------------------------------------
;  EQUATES
;-----------------------------------------------
POWERMASK:     equ 03h
GAINREGMASK:   equ f0h
GAINMASK:      equ f4h
HIGHGAIN:      equ 04h
HIGHGAINMASK:  equ 10h
EXGAIN:        equ 01h

AREA UserModules (ROM, REL)
.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: AMPINV_1_Start
;  FUNCTION NAME: AMPINV_1_SetPower
;
;  DESCRIPTION:
;    Applies power setting to the module's PSoC block.
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;     A  Contains the power settings 0=Off, 1=Low, 2=Med, and 3=High
;
;  RETURNS:  NA
;
;  SIDE EFFECTS:
;     REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;
 AMPINV_1_Start:
_AMPINV_1_Start:
 AMPINV_1_SetPower:
_AMPINV_1_SetPower:

        and  A, POWERMASK       ; isolate bits of interest
        mov  X, SP              ; establish pointer to temp memory
        push A                  ; stash new setting
        mov  A, REG[AMPINV_1_INVAMP_CR2]
        and  A, ~POWERMASK      ; clear previous power setting
        or   A, [X]             ; set power to new value
        mov  REG[AMPINV_1_INVAMP_CR2], A
        pop  A                  ; clean up stack
        ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: AMPINV_1_SetGain
;
;  DESCRIPTION:
;    This function sets the Gain/Atten of the amplifier.  Valid gain settings
;    are defined in the AMPINV_1.inc file.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A  Contains gain settings.
;
;  RETURNS:  NA
;
;  SIDE EFFECTS:
;     REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;     There may be a gain glitch while changing between a low gain setting
;     (less than 23) and a high gain setting (23 or 47). This glitch should
;     be less than 1usec when the CPU clock is set to 12 MHz.
;
 AMPINV_1_SetGain:
_AMPINV_1_SetGain:

    and  A, GAINMASK                              ; mask A to protect unchanged bits
    mov  X, SP                                    ; define temp store location

    push A                                        ; put gain value in temp store
    mov  A, reg[AMPINV_1_INVAMP_CR0]      ; read power value
    and  A, ~GAINREGMASK                          ; clear gain bits in A
    tst  [X],HIGHGAIN                             ; See if High Gain is set
    jnz  .SETHIGHGAIN
    and  reg[AMPINV_1_INVAMP_CR3],~EXGAIN ; Clear High Gain bit.
    or   A, [X]                                   ; combine gain value with balance of reg.
    mov  reg[AMPINV_1_INVAMP_CR0], A      ; move complete value back to register
    pop  A
    ret

.SETHIGHGAIN:
    and  [X],HIGHGAINMASK                         ; Make sure we have a valid high gain
    or   A, [X]                                   ; combine gain value with balance of reg.
    mov  reg[AMPINV_1_INVAMP_CR0], A      ; move complete value back to register
    or   reg[AMPINV_1_INVAMP_CR3], EXGAIN ; Set High Gain bit.
    pop  A
    ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: AMPINV_1_Stop
;
;  DESCRIPTION:
;    This function cuts power to the user module.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;     REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;
 AMPINV_1_Stop:
_AMPINV_1_Stop:

        and REG[AMPINV_1_INVAMP_CR2], FCh
        ret
.ENDSECTION

; End of File AMPINV_1.asm
