//****************************************************************************
// @Module        Project Settings
// @Filename      MAIN.C
// @Project       BLDC.dav
//----------------------------------------------------------------------------
// @Controller    Infineon XC866-4FR
//
// @Compiler      Keil
//
// @Codegenerator 1.6
//
// @Description   This file contains the Project initialization function.
//
//----------------------------------------------------------------------------
// @Date          7/25/2005 1:17:32 AM
//
//****************************************************************************

// USER CODE BEGIN (MAIN_General,1)

// USER CODE END



//****************************************************************************
// @Project Includes
//****************************************************************************

#include "MAIN.H"

// USER CODE BEGIN (MAIN_General,2)

// USER CODE END


//****************************************************************************
// @Macros
//****************************************************************************

// USER CODE BEGIN (MAIN_General,3)

// USER CODE END


//****************************************************************************
// @Defines
//****************************************************************************

// USER CODE BEGIN (MAIN_General,4)

// USER CODE END


//****************************************************************************
// @Typedefs
//****************************************************************************

// USER CODE BEGIN (MAIN_General,5)

// USER CODE END


//****************************************************************************
// @Imported Global Variables
//****************************************************************************

// USER CODE BEGIN (MAIN_General,6)

// USER CODE END


//****************************************************************************
// @Global Variables
//****************************************************************************

// USER CODE BEGIN (MAIN_General,7)
//#define forward
//HallPatt: hall states of current and expected values
//OutputPatt: output values related to the hall states
#ifdef forward
code unsigned char HallPatt[] = {  000,  015,  023,  031,  046,  054,  062};
code unsigned char OutputPatt[] = {0x00, 0x06, 0x21, 0x24, 0x18, 0x12, 0x09};
#else
code unsigned char HallPatt[] = {  000,  013,  026,  032,  045,  051,  064};
code unsigned char OutputPatt[] = {0x00, 0x09, 0x12, 0x18, 0x24, 0x21, 0x06};
#endif
// USER CODE END


//****************************************************************************
// @External Prototypes
//****************************************************************************


// USER CODE BEGIN (MAIN_General,8)

// USER CODE END


//****************************************************************************
// @Prototypes Of Local Functions
//****************************************************************************

// USER CODE BEGIN (MAIN_General,9)

// USER CODE END


//****************************************************************************
// @Function      void MAIN_vInit(void) 
//
//----------------------------------------------------------------------------
// @Description   This function initializes the microcontroller. It is 
//                assumed that the SFRs are in their reset state.
//
//----------------------------------------------------------------------------
// @Returnvalue   None
//
//----------------------------------------------------------------------------
// @Parameters    None
//
//----------------------------------------------------------------------------
// @Date          7/25/2005
//
//****************************************************************************

// USER CODE BEGIN (MAIN_Init,1)

// USER CODE END

void MAIN_vInit(void)
{
  // USER CODE BEGIN (MAIN_Init,2)

  // USER CODE END

  ///  -----------------------------------------------------------------------
  ///  Configuration of the System Clock:
  ///  -----------------------------------------------------------------------
  ///  - On Chip Osc is Selected
  ///  - PLL Mode, NDIV = 2
  ///  - input frequency is 10 MHz



  ///  *********************************************************************************
  ///  Note : All peripheral related IO configurations are done in the 
  ///  respective peripheral modules (alternate functions selection)
  ///  *********************************************************************************


  ///  Initialization of module 'Capture / Compare Unit 6 (CCU6)'
  CC6_vInit();

  //   Interrupt Priority

  IP            =  0x00;         // load Interrupt Priority Register
  IPH           =  0x00;         // load Interrupt Priority High Register
  IP1           =  0x00;         // load Interrupt Priority 1 Register
  IPH1          =  0x00;         // load Interrupt Priority 1 High Register


  // USER CODE BEGIN (MAIN_Init,3)

  // USER CODE END

  //   globally enable interrupts
  EA            =  1;           

} //  End of function MAIN_vInit


//****************************************************************************
// @Function      void main(void) 
//
//----------------------------------------------------------------------------
// @Description   This is the main function.
//
//----------------------------------------------------------------------------
// @Returnvalue   None
//
//----------------------------------------------------------------------------
// @Parameters    None
//
//----------------------------------------------------------------------------
// @Date          7/25/2005
//
//****************************************************************************

// USER CODE BEGIN (MAIN_Main,1)

// USER CODE END

void main(void)
{
  // USER CODE BEGIN (MAIN_Main,2)
 
unsigned char i;
  // USER CODE END

  MAIN_vInit();

  // USER CODE BEGIN (MAIN_Main,3)
#define MCM_transfer 0x80				   	//manual transfer from shadow registers

	i = (P2_DATA & 0x7);					//read in the current hall state

	CCU6_MCMOUTSH = HallPatt[i] | MCM_transfer;	   	//program the curr, exp hall states.
	CCU6_MCMOUTSL = OutputPatt[i] | MCM_transfer;	//program the output pattern to the CCU port.

	i=HallPatt[i]& 0x07;						//get expected hall state

	CCU6_MCMOUTSH = HallPatt[i];		   	//program shadow registers with next state values
	CCU6_MCMOUTSL = OutputPatt[i];			//the shadow transfer will be automatic

  // USER CODE END

  while(1)
  {

  // USER CODE BEGIN (MAIN_Main,4)

  // USER CODE END

  }

} //  End of function main


// USER CODE BEGIN (MAIN_General,10)

// USER CODE END

