//****************************************************************************
// @Module        Capture / Compare Unit 6 (CCU6)
// @Filename      CC6.C
// @Project       BLDC.dav
//----------------------------------------------------------------------------
// @Controller    Infineon XC866-4FR
//
// @Compiler      Keil
//
// @Codegenerator 1.6
//
// @Description   This file contains functions that use the CCU6 module.
//
//----------------------------------------------------------------------------
// @Date          7/25/2005 1:17:33 AM
//
//****************************************************************************

// USER CODE BEGIN (CCU6_General,1)

// USER CODE END



//****************************************************************************
// @Project Includes
//****************************************************************************

#include "MAIN.H"

// USER CODE BEGIN (CCU6_General,2)

// USER CODE END


//****************************************************************************
// @Macros
//****************************************************************************

// USER CODE BEGIN (CCU6_General,3)

// USER CODE END


//****************************************************************************
// @Defines
//****************************************************************************

// USER CODE BEGIN (CCU6_General,4)

// USER CODE END


//****************************************************************************
// @Typedefs
//****************************************************************************

// USER CODE BEGIN (CCU6_General,5)

// USER CODE END


//****************************************************************************
// @Imported Global Variables
//****************************************************************************

// USER CODE BEGIN (CCU6_General,6)

// USER CODE END


//****************************************************************************
// @Global Variables
//****************************************************************************

// USER CODE BEGIN (CCU6_General,7)

// USER CODE END


//****************************************************************************
// @External Prototypes
//****************************************************************************

// USER CODE BEGIN (CCU6_General,8)

// USER CODE END


//****************************************************************************
// @Prototypes Of Local Functions
//****************************************************************************

// USER CODE BEGIN (CCU6_General,9)

// USER CODE END


//****************************************************************************
// @Function      void CC6_vInit(void) 
//
//----------------------------------------------------------------------------
// @Description   This is the initialization function of the CCU6 function 
//                library. It is assumed that the SFRs used by this library 
//                are in their reset state. 
//
//----------------------------------------------------------------------------
// @Returnvalue   None
//
//----------------------------------------------------------------------------
// @Parameters    None
//
//----------------------------------------------------------------------------
// @Date          7/25/2005
//
//****************************************************************************

// USER CODE BEGIN (Init,1)

// USER CODE END

void CC6_vInit(void)
{
  // USER CODE BEGIN (Init,2)

  // USER CODE END

  SFR_PAGE(_cc1, noSST);         // switch to page 1

  ///  -----------------------------------------------------------------------
  ///  Configuration of Timer Control Register
  ///  -----------------------------------------------------------------------

  CCU6_TCTR0L    =  0x07;        // load CCU6 timer control register 0 low
  CCU6_TCTR0H    =  0x00;        // load CCU6 timer control register 0 high

  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 Timer 12:
  ///  -----------------------------------------------------------------------
  ///  - prescaler factor is 128
  ///  - timer 12 run bit is set
  ///  - single shot mode is disabled
  ///  - timer 12 works in edge aligned mode
  ///  - interrupt on period match is disabled
  ///  - interrupt on one match is disabled

  CCU6_T12PRL    =  0xFF;        // load CCU6 T12 period register low
  CCU6_T12PRH    =  0xFF;        // load CCU6 T12 period register lhigh

  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 Timer 13:
  ///  -----------------------------------------------------------------------
  ///  - prescaler factor is 1
  ///  - timer 13 run bit is reset
  ///  - trigger control is disabled
  ///  - single shot mode is disabled
  ///  - interrupt on period match is disabled
  ///  - interrupt on compare match is disabled

  CCU6_T13PRL    =  0x01;        // load CCU6 T13 period register low
  CCU6_T13PRH    =  0x00;        // load CCU6 T13 period register high

  ///  -----------------------------------------------------------------------
  ///  Configuration of Dead-Time Control Register for Timer T12
  ///  -----------------------------------------------------------------------

  CCU6_T12DTCL   =  0x08;        // load CCU6 dead time control register low 
                                 // for timer T12

  CCU6_T12DTCH   =  0x01;        // load CCU6 dead time control register high 
                                 // for timer T12

  SFR_PAGE(_cc0, noSST);         // switch to page 0

  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 Channel 0:
  ///  -----------------------------------------------------------------------
  ///  - hall sensor mode is selected
  ///  - T13 modulation for output CC60 is disabled
  ///  - the output CC60 is set to the passive state
  ///  - the trap functionality of the pin CC60 is disabled
  ///  - the passive level of the output CC60 is '0'
  ///  - T13 modulation for output COUT60 is disabled
  ///  - the output COUT60 is set to the passive state
  ///  - the trap functionality of the pin COUT60 is disabled
  ///  - the passive level of the output COUT60 is '0'
  ///  - dead time generation is enabled

  ///  - generation interrupt on flag ICC60R is disabled
  ///  - generation interrupt on flag ICC60F is disabled

  CCU6_CC60SRL   =  0x00;        // load CCU6 capture/compare shadow register 
                                 // low for channel 0
  CCU6_CC60SRH   =  0x00;        // load CCU6 capture/compare shadow register 
                                 // high for channel 0


  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 Channel 1:
  ///  -----------------------------------------------------------------------
  ///  - hall sensor mode is selected
  ///  - T13 modulation for output CC61 is disabled
  ///  - the output CC61 is set to the passive state
  ///  - the trap functionality of the pin CC61 is disabled
  ///  - the passive level of the output CC61 is '0'
  ///  - T13 modulation for output COUT61 is disabled
  ///  - the output COUT61 is set to the passive state
  ///  - the trap functionality of the pin COUT61 is disabled
  ///  - the passive level of the output COUT61 is '0'
  ///  - dead time generation is disabled

  ///  - generation interrupt on flag ICC61R is disabled
  ///  - generation interrupt on flag ICC61F is disabled

  CCU6_CC61SRL   =  0x00;        // load CCU6 capture/compare shadow register 
                                 // low for channel 1
  CCU6_CC61SRH   =  0x00;        // load CCU6 capture/compare shadow register 
                                 // high for channel 1


  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 Channel 2:
  ///  -----------------------------------------------------------------------
  ///  - hall sensor mode is selected
  ///  - T13 modulation for output CC62 is disabled
  ///  - the output CC62 is set to the passive state
  ///  - the trap functionality of the pin CC62 is disabled
  ///  - the passive level of the output CC62 is '0'
  ///  - T13 modulation for output COUT62 is disabled
  ///  - the output COUT62 is set to the passive state
  ///  - the trap functionality of the pin COUT62 is disabled
  ///  - the passive level of the output COUT62 is '0'
  ///  - dead time generation is disabled

  ///  - generation interrupt on flag ICC62R is disabled
  ///  - generation interrupt on flag ICC62F is disabled

  CCU6_CC62SRL   =  0x00;        // load CCU6 capture/compare shadow register 
                                 // low for channel 2
  CCU6_CC62SRH   =  0x00;        // load CCU6 capture/compare shadow register 
                                 // high for channel 2


  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 Channel 3:
  ///  -----------------------------------------------------------------------
  ///  - T13 output is not inverted


  CCU6_CC63SRL   =  0x00;        // load CCU6 capture/compare shadow register 
                                 // low for channel 3
  CCU6_CC63SRH   =  0x00;        // load CCU6 capture/compare shadow register 
                                 // high for channel 3


  ///  -----------------------------------------------------------------------
  ///  Configuration of Multi-Channel Mode Output Register
  ///  -----------------------------------------------------------------------

  CCU6_MCMOUTSL  =  0x00;        // load CCU6 multi channel mode output 
                                 // control register low
  CCU6_MCMOUTSH  =  0x00;        // load CCU6 multi channel mode output 
                                 // control register high


  SFR_PAGE(_cc2, noSST);         // switch to page 2

  ///  -----------------------------------------------------------------------
  ///  Configuration of Timer Control Register
  ///  -----------------------------------------------------------------------

  CCU6_TCTR2L    =  0x00;        // load CCU6 timer control register 2 low
  CCU6_TCTR2H    =  0x00;        // load CCU6 timer control register 2 high

  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 trap control:
  ///  -----------------------------------------------------------------------
  ///  - a trap can only be generated by SW by setting the bit TRPF
  ///  - the trap state is left when a zero-match of T12 (while counting up) 
  ///    is detected (synchronization to T12)
  ///  - bit TRPF is automatically cleared by HW (according to TRPPEN, TRPM0 
  ///    and TRPM1)
  ///  - trap interrupt is disabled

  CCU6_TRPCTRL   =  0x00;        // load CCU6 trap control register low
  CCU6_TRPCTRH   =  0x00;        // load CCU6 trap control register high

  ///  -----------------------------------------------------------------------
  ///  Configuration of Multi Channel Mode:
  ///  -----------------------------------------------------------------------
  ///  - multi channel mode is enabled

  ///  - switching selection:
  ///  - transfer on correct hall event

  ///  - switching synchronization:
  ///  - direct transfer

  ///  - interrupt on correct hall event is enabled
  ///  - interrupt on wrong hall event is disabled
  ///  - the automatic entering of the idle state is disabled

  CCU6_MODCTRL   =  0x80;        // load CCU6 modulation control register low
  CCU6_MODCTRH   =  0x00;        // load CCU6 modulation control register high

  ///  -----------------------------------------------------------------------
  ///  Configuration of Multi_Channel Mode Control Register
  ///  -----------------------------------------------------------------------

  CCU6_MCMCTR    =  0x01;        // load CCU6 multi channel mode control 
                                 // register 

  ///  -----------------------------------------------------------------------
  ///  Configuration of T12 Capture/Compare Mode Select Register
  ///  -----------------------------------------------------------------------

  CCU6_T12MSELL  =  0x88;        // load CCU6 T12 campture/compare mode 
                                 // select register low

  CCU6_T12MSELH  =  0x08;        // load CCU6 T12 campture/compare mode 
                                 // select register high
  ///  -----------------------------------------------------------------------
  ///  Configuration of Passive State Level Register
  ///  -----------------------------------------------------------------------

  CCU6_PSLR      =  0x00;        // load CCU6 passive state level register low

  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 interrupt control:
  ///  -----------------------------------------------------------------------
  ///  - for channel 0 interrupts is node I3 selected
  ///  - for channel 1 interrupts is node I3 selected
  ///  - for channel 2 interrupts is node I3 selected
  ///  - for correct hall event interrupt is node I3 selected
  ///  - for error interrupts is node I3 selected
  ///  - for T12 interrupts is node I3 selected
  ///  - for T13 interrupts is node I3 selected

  CCU6_INPL      =  0xFF;        // load CCU6 capture/compare interrupt node 
                                 // pointer register low
  CCU6_INPH      =  0x3F;        // load CCU6 capture/compare interrupt node 
                                 // pointer register high

  CCU6_IENL      =  0x00;        // load CCU6 capture/compare interrupt 
                                 // enable register low
  CCU6_IENH      =  0x10;        // load CCU6 capture/compare interrupt 
                                 // enable register high

  SFR_PAGE(_cc3, noSST);         // switch to page 3

  ///  -----------------------------------------------------------------------
  ///  Configuration of Compare State Register
  ///  -----------------------------------------------------------------------

  CCU6_CMPSTATH  =  0x00;        // load CCU6 compare status register high

  ///  -----------------------------------------------------------------------
  ///  Configuration of CCU6 module input signals:
  ///  -----------------------------------------------------------------------
  ///  - signal CC60_0 is used as output
  ///  - signal CC61_0 is used as output
  ///  - signal CC62_0 is used as output
  ///  - signal #CTRAP is not used

  CCU6_PISEL0L   =  0x00;        // load CCU6 Port Input Select Register 0 Low

  ///  - signal CCPOS0_0 is used
  ///  - signal CCPOS1_0 is used
  ///  - signal CCPOS2_0 is used
  ///  - signal T12HR is not used

  CCU6_PISEL0H   =  0x00;        // load CCU6 Port Input Select Register 0 
                                 // High

  ///  - signal T13HR is not used

  CCU6_PISEL2    =  0x00;        // load CCU6 Port Input Select Register 2

  ///  Pin P3.0 is used as CC60_0 Output 
  ///  Pin P3.1 is used as COUT60_0 Output 
  ///  Pin P3.2 is used as CC61_0 Output 
  ///  Pin P3.3 is used as COUT61_0 Output 
  ///  Pin P3.4 is used as CC62_0 Output 
  ///  Pin P3.5 is used as COUT62_0 Output 

  SFR_PAGE(_pp2, noSST);         // switch to page 2
  P3_ALTSEL0      |= 0x3F;     //  set AltSel0 
  P3_ALTSEL1      &= ~(ubyte)0x3F;              //  set AltSel1

  SFR_PAGE(_pp0, noSST);         // switch to page 0
  P3_DIR          |= 0x3F;      //  set P3.7 OutPut



  ///  -----------------------------------------------------------------------
  ///  Configuration of the used CCU6 Channels Interrupts:
  ///  -----------------------------------------------------------------------
  ///  - capture/compare interrupt node 0 is disabled
  ///  - capture/compare interrupt node 1 is disabled
  ///  - capture/compare interrupt node 2 is disabled
  ///  - capture/compare interrupt node 3 is enabled

  IEN1          |=  0x80;        // load interrupt enable register 2


  SFR_PAGE(_cc0, noSST);         // switch to page 0

  ///  -----------------------------------------------------------------------
  ///  Timer Control Register
  ///  -----------------------------------------------------------------------
  ///  -  enable shadow transfer to T12 and T13

  CCU6_TCTR4L    =  0x40;        // load CCU6 timer control register 4 low

  CCU6_TCTR4H    =  0x40;        // load CCU6 timer control register 4 high

  ///  Start timer settings 

  CCU6_TCTR4L    =  0x02;        // start timer 12


  // USER CODE BEGIN (Init,3)

  // USER CODE END

} //  End of function CC6_vInit

//****************************************************************************
// @Function      void CC6_viNodeI3(void) 
//
//----------------------------------------------------------------------------
// @Description   This is the interrupt service routine for the CC6 node I3. 
//                If the content of the corresponding compare timer 
//                (configurable) equals the content of the capture/compare 
//                register or if a capture event occurs at the associated 
//                port pin, the interrupt request flag is set and an 
//                interrupt is triggered (only if enabled).
//                Please note that you have to add application specific code 
//                to this function.
//
//----------------------------------------------------------------------------
// @Returnvalue   None
//
//----------------------------------------------------------------------------
// @Parameters    None
//
//----------------------------------------------------------------------------
// @Date          7/25/2005
//
//****************************************************************************

// USER CODE BEGIN (NodeI3,1)

// USER CODE END

void CC6_viNodeI3(void) interrupt CCU6_NodeI3_INT
{

  // USER CODE BEGIN (NodeI3,2)
extern code unsigned char HallPatt[];
extern code unsigned char OutputPatt[];
unsigned char temp;
  // USER CODE END

  SFR_PAGE(_cc3, SST2);          // switch to page 3

  if(CCU6_ISH & 0x10)   //if ISH_CHE
  {
    //correct hall event detection

    SFR_PAGE(_cc0, noSST);       // switch to page 0

    CCU6_ISRH = 0x10;  //clear flag ISH_CHE

    // USER CODE BEGIN (NodeI3,23)
	temp = CCU6_MCMOUTSH & 0x07;   		//get next hall state
	CCU6_MCMOUTSL = OutputPatt[temp];	//program shadow registers with next state values
	CCU6_MCMOUTSH = HallPatt[temp];	   	//the shadow transfer will be automatic
    // USER CODE END

  }

  SFR_PAGE(_cc0, RST2);          // restore the old CCU page


} //  End of function CC6_viNodeI3


// USER CODE BEGIN (CCU6_General,10)

// USER CODE END

